﻿var panelGroups = {
    context: $(".v-panelGroups"),
    datatable: null,
    initializeDataTable: function () {
        this.datatable = $(".v-panelGroupsTable", this.context).a4datatable({
            height: "full",
            stateKey: "SettingsPanelGroups",
            ajaxAction: a4.getAction("GetPanelGroups", "Home", "Panel"),
            columns: [
                { "Name": "Id", "Title": resources.Id },
                { "Name": "Name", "Title": resources.Name, "HideInSelector": true },
                { "Name": "Description", "Title": resources.Description },
                { "Name": "ModifiedBy", "Title": resources.ModifiedBy },
                { "Name": "ModifiedOn", "Title": resources.ModifiedOn }
            ],            
            toolBarItems: panelGroups.getToolBarItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;

                if (action == "delete") {
                    panelGroups.deleteItems(_.pluck(rows, "Id"));
                }
            },
            contextMenuItems: panelGroups.getContextMenuItems(),
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                if (action == "properties") {
                    modalDialog.showWindow(a4.getAction("EditGroup", "Home", "Panel", { id: row.Id }), 250, 600, { afterClose: function () { panelGroups.refreshDataTable(); } });
                }
                else if (action == "delete") {
                    panelGroups.deleteItems(row.Id);
                }
            },
            localizableTexts: { "Search": resources.SearchPanelGroups }
        });
    },
    bindEvents: function () {
        $(document).on("click", ".h-importGroups", function () {
            modalDialog.showWindow(a4.getAction("ImportGroups", "Home", "Panel"), 450, 650, { afterClose: function () { panelGroups.refreshDataTable(); } });
        });

        $(document).on("click", ".h-addGroup", function () {
            modalDialog.showWindow(a4.getAction("EditGroup", "Home", "Panel"), 250, 600, { afterClose: function () { panelGroups.refreshDataTable(); } });
        });
    },
    refreshDataTable: function () {
        this.datatable.a4datatable("refresh");
    },
    deleteItems: function (items) {
        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        modalDialog.showConfirmDialog(confirmDeleteItemResources, function () {
            a4.callServerMethod(a4.getAction("DeleteGroups", "Home", "Panel"), { ids: items },
                function (result) {
                    panelGroups.refreshDataTable();
                });
        }, 250, 500, true, { "count": itemsCount });
    },
    canModifyPanel: $("#CanModifyPanel").val() == "True",
    getToolBarItems: function () {
        var items = [];

        if (this.canModifyPanel) {
            items.push({ "Action": "delete", "Label": resources.Delete });
        }

        return items;
    },
    getContextMenuItems: function () {
        var items = [];

        if (this.canModifyPanel) {
            items.push({ "Action": "delete", "Label": resources.Delete });
            items.push({ "Action": "properties", "Label": resources.Properties });
        }

        return items;
    }
}

$(document).ready(function () {
    if (panelGroups.context.length > 0) {
        panelGroups.initializeDataTable();
        panelGroups.bindEvents();
    }
});